﻿/****** Object:  StoredProcedure [puma].[PatientMasterUpdate]    Script Date: 06/20/2013 10:12:00 ******/
DROP PROCEDURE [puma].[PatientMasterUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 22 January 2013
-- Description:   Updates an existing record in the Patient Master table and removes overrides where the values match. 
-- =============================================
CREATE PROCEDURE [puma].[PatientMasterUpdate] 
(
    @PatientMasterId INT,
	@CurrentSexId INT,
	@DeathIndicatorId INT = null,
	@DateOfBirth DATETIME,
	@DateOfDeath DATETIME = null,
	@MedicareNumber VARCHAR(12) = null,
	@MedicareIrn VARCHAR(3) = null,
	@IsMedicareNumberValid INT = null,
	@DvaNumber VARCHAR(18) = NULL,	 
	@StatePatientId VARCHAR(64) = NULL, 
	@UserModified VARCHAR(256),
	@DateModified datetime,
	@HealthProviderOrganisationNetworkId INT
)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (
		SELECT TOP 1 [DateModified]
		FROM  [hips].[PatientMaster]
		WHERE [PatientMasterId] = @PatientMasterId
		AND [DateModified] = @DateModified)
    BEGIN
		DECLARE @DateModifiedText NVARCHAR(30)
		SET @DateModifiedText = CAST(@DateModified AS NVARCHAR)
		RAISERROR (50001, -1, -1, N'PatientMaster', N'PatientMasterID', @PatientMasterID, N'DateModified', @DateModifiedText)
        SET @intErrorCode = @@ERROR
    END
	IF @intErrorCode = 0
	BEGIN
		UPDATE [hips].[PatientMaster]
           SET [CurrentSexId] = @CurrentSexId
			  ,[DateOfBirth] = @DateOfBirth
			  ,[DateOfDeath] = @DateOfDeath
			  ,[DeathIndicatorId] = @DeathIndicatorId 
			  ,[MedicareNumber] = @MedicareNumber
			  ,[MedicareIrn] = @MedicareIrn
			  ,[IsMedicareNumberValid] = @IsMedicareNumberValid
			  ,[DvaNumber] = @DvaNumber
			  ,[StatePatientId] = @StatePatientId
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
		 WHERE [PatientMasterID] = @PatientMasterID
		SELECT @intErrorCode = @@ERROR     
		IF @intErrorCode = 0
		BEGIN
			UPDATE [puma].[PatientMasterOverride]
			   SET [MedicareNumber] = CASE WHEN [MedicareNumber] = @MedicareNumber THEN NULL ELSE [MedicareNumber] END
			      ,[IsMedicareNumberValid] = CASE WHEN [IsMedicareNumberValid] = @IsMedicareNumberValid THEN NULL ELSE [IsMedicareNumberValid] END
			      ,[MedicareIrn] = CASE WHEN [MedicareIrn] = @MedicareIrn THEN NULL ELSE [MedicareIrn] END
			      ,[DvaNumber] = CASE WHEN [DvaNumber] = @DvaNumber THEN NULL ELSE [DvaNumber] END
			      ,[DateOfBirth] = CASE WHEN [DateOfBirth] = @DateOfBirth THEN NULL ELSE [DateOfBirth] END
			 WHERE [PatientMasterId] = @PatientMasterId
			SELECT @intErrorCode = @@ERROR
			IF @intErrorCode = 0
			BEGIN
				DELETE [puma].[PatientMasterOverride]
				 WHERE [PatientMasterId] = @PatientMasterId
				   AND [MedicareNumber] IS NULL
				   AND [IsMedicareNumberValid] IS NULL
				   AND [MedicareIrn] IS NULL
				   AND [DvaNumber] IS NULL
				   AND [DateOfBirth] IS NULL
				SELECT @intErrorCode = @@ERROR
			END
		END
	END
    IF @intErrorCode = 0
    BEGIN
		SELECT pm.[PatientMasterID]
			 , COALESCE (pmi.RegisteredSexId,pm.CurrentSexId, -1) AS RegisteredSexId
			 , COALESCE (pm.CurrentSexId, -1) AS CurrentSexId
			 , pmi.Ihi
			 , COALESCE (pmi.IhiStatusId, -1) AS IhiStatusId
			 , ihis.Description AS IhiStatus
			 , COALESCE (pmi.IhiRecordStatusId, -1) AS IhiRecordStatusId
			 , pmi.[RegisteredFamilyName]
			 , pmi.[RegisteredGivenName]
			 , irs.Description AS IhiRecordStatus
			 , pmi.DateLastValidated AS IhiLastValidated
			 , COALESCE(pmo.MedicareNumber,pm.MedicareNumber) AS MedicareNumber
			 , COALESCE(pmo.IsMedicareNumberValid,pm.IsMedicareNumberValid) AS IsMedicareNumberValid
			 , COALESCE(pmo.MedicareIrn,pm.MedicareIrn) AS MedicareIrn
			 , COALESCE(pmo.DvaNumber,pm.DvaNumber) AS DvaNumber
			 , pm.[StatePatientId]
			 , COALESCE(pmo.DateOfBirth,pm.DateOfBirth) AS DateOfBirth
			 , COALESCE (pmi.RegisteredDateOfBirth, pm.DateOfBirth) AS RegisteredDateOfBirth
			 , pm.[DateOfDeath]
			 , pm.[DateCreated]
			 , pm.[UserCreated]
			 , pm.[DateModified]
			 , pm.[UserModified]         
			 , pmi.[HealthProviderOrganisationNetworkId]
	     FROM	[hips].[PatientMaster] AS pm
		 LEFT JOIN [hips].[HospitalPatient] AS hp ON pm.PatientMasterId = hp.PatientMasterId
	     LEFT JOIN [hips].[Hospital] AS h ON hp.HospitalId = h.HospitalId
	     LEFT JOIN [hips].[HealthProviderOrganisation] AS hpo ON h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId
         LEFT JOIN [hips].[PatientMasterIhi] AS pmi ON pmi.[PatientMasterID] = pm.[PatientMasterID] AND pmi.HealthProviderOrganisationNetworkId = @HealthProviderOrganisationNetworkId
         LEFT JOIN [hips].IhiRecordStatus AS irs on irs.IhiRecordStatusId = pmi.IhiRecordStatusId
		 LEFT JOIN [hips].IhiStatus AS ihis on ihis.IhiStatusId = pmi.IhiStatusId
		 LEFT JOIN [puma].[PatientMasterOverride] AS pmo ON pmo.[PatientMasterId] = pm.[PatientMasterId]

        WHERE	pm.[PatientMasterID] = @PatientMasterID
    END

    RETURN(@intErrorCode)

END
GO
